<?php


function formatPostContent($content) {
	return str_replace("\n", "<br>", htmlentities($content));
}

function ellipsis($string, $length, $stopanywhere=false) {
    //truncates a string to a certain char length, stopping on a word if not specified otherwise.
    if (strlen($string) > $length) {
        //limit hit!
        $string = substr($string,0,($length -3));
        if ($stopanywhere) {
            //stop anywhere
            $string .= '...';
        } else{
            //stop on a word.
            $string = substr($string,0,strrpos($string,' ')).'...';
        }
    }
    return $string;
}

function formatS($n, $str) {
	if(intval($n) === 1) {
		return $n." ".$str;
	}
	else {
		return $n." ".$str."s";
	}
}

function timeAgo($time) {
	$days = floor($time/(60*60*24));
	$hours = floor($time/(60*60)) % 24;
	$minutes = floor($time/60) % 60;
	$seconds = floor($time) % 60;
	
	$ago = $days > 0 ? "$days day" : (
		   $hours > 0 ? "$hours hour" : (
		   $minutes > 0 ? "$minutes minute" : (
		   "$seconds second")));
	$parts = explode(" ", $ago);
	$ago .= intval($parts[0]) === 1 ? "" : "s";
	return $ago;
}
