// slideshow.js - made by djazz
/**
 Usage:
 
 <a href="image1.jpg" data-slideshow="mySlideShow" title="Image 1 title"><img src="image1_thumb.jpg"></a>
 <a href="image2.jpg" data-slideshow="mySlideShow" title="Image 2 title"><img src="image2_thumb.jpg"></a>
**/
'use strict';
(function (global, undefined) {
	var slideshows = {};
	
	var domSlideshows = {};
	
	var slideshowVisible = false;
	var canStart = true;
	var domSlideshow = global.document.createElement('div');
	var currentIndex;
	var currentSlide;
	var currentName;
	
	var imageWidth = 640;
	var imageHeight = 426;
	
	var imageCache = {};
	
	domSlideshow.id = "slideshow";
	domSlideshow.innerHTML = "<table id=\"slideTable\"><tbody>"+
		"<tr><td id=\"slideshowcenter\"><table id=\"slideContainer\" align=center cellspacing=0 cellpadding=0>"+
		"<tr><td colspan=3><div id=\"slideClose\"></div></td></tr>"+
		"<tr><td colspan=3 id=\"slideImageContainer\"><div id=\"slideImages\"></div></td></tr><tr>"+
		"<td width=1><input type=button id=\"slidePrevButton\"></td><td valign=top><div id=\"slideCaption\"></div></td><td width=1 align=right><input type=button id=\"slideNextButton\"></td>"+
		"</tr></table></td></tr></tbody></table>";
	
	global.document.getElementsByTagName('body')[0].appendChild(domSlideshow);
	var slideshowcenter = global.document.getElementById('slideshowcenter');
	var slideContainer = global.document.getElementById('slideContainer');
	var slideImages = global.document.getElementById('slideImages');
	var slideCaption = global.document.getElementById('slideCaption');
	var prevButton = global.document.getElementById('slidePrevButton');
	var nextButton = global.document.getElementById('slideNextButton');
	var closeButton = global.document.getElementById('slideClose');
	
	slideContainer.style.width = (imageWidth+20)+"px";
	slideImages.style.height = imageHeight+"px";
	var supportSliding = (function () {
		return slideImages.style.transition !== undefined ||
			slideImages.style.webkitTransition !== undefined ||
			slideImages.style.MozTransition !== undefined ||
			slideImages.style.OTransition !== undefined;
	}());
	
	global.onkeydown = function (e) {
		if(slideshowVisible || domSlideshow.style.visibility === 'visible') {
			var e = e || global.event;
			var kc = e.keyCode;
			var doBlock = true;
			switch(kc) {
				case 37:
					step(false);
					break;
				case 39:
					step(true);
					break;
				case 27:
					closeSlideshow();
					break;
				default:
					doBlock = false;
			};
			if(doBlock) {
				e.preventDefault();
				e.returnValue = false;
				return false;
			}
		}
	};
	prevButton.onclick = function () {
		step(false);
	};
	nextButton.onclick = function () {
		step(true);
	};
	slideImages.onclick = function () {
		step(true);
	};
	closeButton.onclick = function () {
		closeSlideshow();
	};
	slideshowcenter.onclick = function (e) {
		e = e || global.event;
		if(e.target === slideshowcenter) {
			closeSlideshow();
		}
	};
	
	var thumbClick = function () {
		if (!canStart) return false;
		var slideName = this.getAttribute('data-slideshow').toLowerCase();
		var index = slideshows[slideName].indexOf(this);
		currentIndex = index;
		currentName = slideName;
		currentSlide = slideshows[slideName];
		changeImage();
		updateCaption();
		domSlideshows[slideName].style.display = 'block';
		domSlideshow.style.visibility = 'visible';
		setTimeout(function () {
			domSlideshow.style.opacity = '1';
		}, 0);
		slideshowVisible = true;
		return false;
	};
	
	var closeSlideshow = function () {
		domSlideshow.style.opacity = '0';
		slideshowVisible = false;
		setTimeout(function () {
			domSlideshow.style.visibility = 'hidden';
			domSlideshows[currentName].style.display = 'none';
			domSlideshows[currentName].style.left = '0px';
		}, supportSliding? 300: 0);
	};
	
	var changeImage = function () {
		domSlideshows[currentName].style.left = (-currentIndex*imageWidth)+"px";
	};
	
	var step = function (forward) {
		currentIndex += forward ? 1 : -1;
		if(currentIndex >= currentSlide.length) currentIndex = 0;
		else if(currentIndex < 0) currentIndex = currentSlide.length-1;
		changeImage();
		updateCaption();
	};
	
	var updateCaption = function () {
		slideCaption.innerHTML = currentSlide[currentIndex].title || "";
	};
	
	var allAnchors = global.document.getElementsByTagName("A");
	var slideshowName;
	for (var i = 0; i < allAnchors.length; i += 1) {
		if (allAnchors[i].getAttribute('data-slideshow') !== null) {
			slideshowName = allAnchors[i].getAttribute('data-slideshow').toLowerCase();
			if (slideshows[slideshowName] === undefined) {
				slideshows[slideshowName] = [];
			}
			slideshows[slideshowName].push(allAnchors[i]);
			allAnchors[i].onclick = thumbClick;
		}
	}
	for(var i in slideshows) {
		domSlideshows[i] = global.document.createElement('div');
		domSlideshows[i].className = "slideImages";
		for(var j=0; j < slideshows[i].length; j+=1) {
			var img = new Image();
			img.src = slideshows[i][j].href;
			img.width = imageWidth;
			domSlideshows[i].appendChild(img);
		}
		domSlideshows[i].style.width = j*imageWidth+"px";
		domSlideshows[i].style.height = imageHeight+"px";
		slideImages.appendChild(domSlideshows[i]);
	}
	
}(window));