#!/usr/bin/env node

var ical = require('ical');

var calendarUrl = "https://www.google.com/calendar/ical/i5s3ijut8rqir8sm751ksf1org%40group.calendar.google.com/public/basic.ics";

var schedule = {};


function updateSchedule(cb) {
	ical.fromURL(calendarUrl, {}, function (err, data) {
		if (err) {
			console.log(""+err);
			cb(err);
			return;
		}
		var now = Date.now();
		for (var eventId in data) {
			var ev = data[eventId];

			if (!ev.end) {
				continue;
			}

			var endTime = ev.end.getTime();
			if (endTime < now) {
				if (schedule.hasOwnProperty(eventId)) {
					console.log("past event deleted: ", schedule[eventId].summary);
					delete schedule[eventId];
				}
				continue;
			}
			if (!schedule[eventId]) {
				console.log("event added: ", ev.summary);
			}
			schedule[eventId] = ev;
		}

		for (var eventId in schedule) {
			if (!data.hasOwnProperty(eventId)) {
				console.log("event deleted: ", schedule[eventId].summary);
				delete schedule[eventId];
			}
		}

		if (typeof cb === 'function') {
			cb(null);
		}
	});
}



function loop(err) {
	//console.log("current events:");
	for (var eventId in schedule) {
		//console.log(schedule[eventId].summary);
	}
	//console.log("");

	setTimeout(function () {
		updateSchedule(loop);
	}, 5*1000);
}
//updateSchedule(loop);
