#!/usr/bin/env node
'use strict';
var express = require('express');
var logger = require('morgan');
var path = require('path');
var mysql = require('mysql');
var bodyParser = require('body-parser');
var schedule = require('node-schedule');

var db = mysql.createConnection({
	host     : 'localhost',
	user     : 'root',
	password : '',
	database : 'paraspriteradio',
	multipleStatements: true
});


var app = express();
//app.use(logger('dev'));
app.use(bodyParser.urlencoded({extended: true}));

app.get('/data', function(req, res){
	db.query('SELECT * FROM events', function (err, rows) {
		if (err) {
			console.log(err);
			return;
		}
		res.send(rows);
	});
});


app.post('/data', function(req, res){
		var data = req.body;

		//get operation type
		var status = data["!nativeeditor_status"];
		var respStatus = status;
		//get id of record
		var sid = data.id;
		var tid = sid;

		var text = data.text;

		var start_date = data.start_date;
		var end_date = data.end_date;

		var type = data.rec_type || "";
		var pid = +data.event_pid || undefined;
		var event_length = +data.event_length || undefined;

		console.log(status, sid, text, start_date, end_date, type, pid, event_length);

		var sql = [];
		var needsCleanup = false;
		
		function callback(err, result) {
			
			if (err) {
				respStatus = "error";
				console.log(err+"");
			} else if (status == "inserted") {
				tid = result.insertId;
			}

			res.setHeader("Content-Type","text/xml");
			res.send("<data><action type='"+respStatus+"' sid='"+sid+"' tid='"+tid+"'/></data>");

			if (needsCleanup) {
				cleanup();
			}
		}

		function cleanup() {
			db.query("SELECT count(*) AS count, (SELECT rec_type FROM events WHERE id=?) AS type FROM events WHERE event_pid=? AND rec_type='none'", [pid, pid], function (err, result) {
				if (err) {
					console.log(err+"");
					return;
				}
				var noneCount = result[0].count;
				var t = result[0].type;
				var totalCount = t.split("#")[1] || undefined;
				totalCount = +totalCount;
				if (noneCount >= totalCount) {
					db.query("DELETE FROM events WHERE event_pid=? OR id=?", [pid, pid], function (err, result) {
						if (err) {
							console.log(err+"");
							return;
						}
						console.log(result);
					});
				}
			});
		}

		// some logic specific for recurring events
		function deleteRelated() {
			var finished = false;
			if ((status === 'deleted' || status === 'updated') && type) {
				// if an event with a rec_type was updated or deleted - all records with the related event_pid must be deleted;
				sql.push(mysql.format("DELETE FROM events WHERE event_pid=?", [sid]));
			}
			// if an event with non-default event_pid value was deleted - it need to be updated with rec_type = "none" instead of deleting.
			if (status === 'deleted' && pid !== undefined) {
				sql.push(mysql.format("UPDATE events SET rec_type='none' WHERE id=?", [sid]));
				needsCleanup = true;
				finished = true; //in this case no more processing is needed
			}
			return finished;
		}

		if (!deleteRelated()) {
			switch (status) {
				case 'inserted':
					sql.push(mysql.format(
						'INSERT INTO events (text, start_date, end_date, rec_type, event_pid, event_length) VALUES (?,?,?,?,?,?)',
						[text, start_date, end_date, type, pid, data.event_length]
					));
					if (type === 'none') {
						needsCleanup = true;
						// if an event with (rec_type == "none") was inserted - the response must have "deleted" status
						status = 'deleted';
					}
					break;

				case 'deleted':
					sql.push(mysql.format('DELETE FROM events WHERE id=? LIMIT 1', [sid]));
					break;

				case 'updated':
					sql.push(mysql.format(
						'UPDATE events SET text=?, start_date=?, end_date=?, rec_type=?, event_pid=?, event_length=? WHERE id=? LIMIT 1',
						[text, start_date, end_date, type, pid, event_length, sid]
					));
					break;

				default:
					res.send("Not supported operation");
					return;
			}
		}

		console.log(sql.join("; "));
		db.query(sql.join("; "), callback);
});

app.use('/scheduler/', express.static(path.join(__dirname, 'bower_components/scheduler/codebase')));
app.use(express.static(path.join(__dirname, 'www')));


app.listen(3000, function () {
	console.log("express server started");
});


function updateSchedule() {
	db.query('SELECT * FROM events WHERE start_date >= NOW() OR end_date >= NOW()', function (err, rows) {
		if (err) {
			console.log(err);
			return;
		}
		var now = Date.now();
		for (var i = 0; i < rows.length; i++) {
			if (rows[i].rec_type !== '') continue; // No repeating for now
			var start = rows[i].start_date;
			var end = rows[i].start_date;
			if (start.getTime() < now) continue; // Skip past events

			var s = schedule.scheduleJob(start, function () {
				console.log("event occured!!!");
			});
			console.log(s);
			console.log(schedule);
		}
		console.log(rows);
	});
}

updateSchedule();
