

DROP TABLE IF EXISTS `events`;
		

CREATE TABLE `events` (
  `id` INTEGER NOT NULL AUTO_INCREMENT,
  `text` MEDIUMTEXT NOT NULL,
  `start_date` DATETIME NOT NULL,
  `end_date` DATETIME NOT NULL,
  `event_pid` INTEGER NULL DEFAULT NULL,
  `event_length` INTEGER NULL DEFAULT NULL,
  `rec_type` VARCHAR(50) NOT NULL,
  PRIMARY KEY (`id`)
);

ALTER TABLE `events`
	ADD FOREIGN KEY (event_pid)
	REFERENCES `events` (`id`)
	ON DELETE CASCADE
	ON UPDATE CASCADE;



INSERT INTO `events` (text, start_date, end_date) VALUES ("Test", "2015-01-19 12:00:00", "2015-01-19 15:00:00");

INSERT INTO `events` (
	text,
	start_date,
	end_date,
	event_length,
	rec_type
) VALUES (
	"Repeating",
	"2015-01-07 07:00",
	"2015-01-28 07:00",
	3600,
	"week_1___3#3"
);
