// Made by Daniel J (djazz)
// http://djazz.mine.nu/
// @daniel_hede on twitter

// shim layer with setTimeout fallback
window.requestAnimFrame = (function(){
  return  window.requestAnimationFrame       ||
          window.webkitRequestAnimationFrame ||
          window.mozRequestAnimationFrame    ||
          function( callback ){
            window.setTimeout(callback, 1000 / 0);
          };
})();

(function () {
	'use strict';
	
	// Configurable
	var airDate = new Date(Date.UTC(2013, 10-1, 11, 11, 0, 0)); // Year, month-1, day, hour, minute, second (UTC)
	var daysBefore = 14;

	// The logic is below this line
	var airTime = airDate.getTime();
	var timeBefore = daysBefore*24*60*60;
	var startTime = new Date().getTime();
	var firstUpdate = true;

	function zf(v) {
		if (v > 9) {
			return v;
		} else {
			return "0"+v;
		}
	}

	function readableTime(time) {
		if (time < 60) return zf(time)+"s";
		else if (time < 3600) return zf(time / 60|0)+"m "+zf(time % 60)+"s";
		else if (time < 86400) return zf(time / 3600|0)+"h "+zf((time % 3600)/60|0)+"m "+zf((time % 3600)%60)+"s";
		else return (time / 86400|0)+"d "+zf((time % 86400)/3600|0)+"h "+zf((time % 3600)/60|0)+"m "+zf((time % 3600)%60)+"s";
	}
	
	var countdownDiv = document.getElementById('countdown');
	var headingDiv = document.getElementById('heading');
	var counterDiv = document.getElementById('counter');
	var progressbar = document.getElementById('progressbar');
	var progress = document.getElementById('progress');
	var aboutDiv = document.getElementById('about');
	
	countdownDiv.setAttribute('title', airDate);
	if (top !== self) {
		document.getElementById('iframecode').style.display = "none";
	}
	
	var numbers = new Array("", "", "", undefined, "", "", undefined, "", "", undefined, "", "", undefined);
	
	function update() {
		var now = new Date().getTime();
		var timeLeft = Math.max((airTime - now)/1000, 0);
		//var timeOffset = (now - startTime)/1000;

		var hoursTotal = timeLeft/(60*60) | 0;
		var minutesTotal = timeLeft/60 | 0;
		var secondsTotal = timeLeft | 0;
		
		var daysLeft = timeLeft / (24*60*60) | 0;
		var hoursLeft = timeLeft % (24*60*60) / (60*60) | 0;
		var minutesLeft = timeLeft % (60*60) / 60 | 0;
		var secondsLeft = timeLeft % 60 | 0;


		var percentage = 1-Math.min(Math.max(timeLeft/timeBefore, 0.0001), 0.9999);
		if (percentage === 0) percentage = 1;
		
		if (timeLeft <= 0) {
			countdownDiv.className = "finished";
		}
		
		progress.style.width = percentage*100+"%";
		if (percentage > 0.0001) {
			progressbar.className = "active";
		}
		
		if (firstUpdate) {
			firstUpdate = false;
			counterDiv.style.opacity = 1;
		}
		
		
		var newNumbers = [
			daysLeft, undefined,
			hoursLeft%100/10|0, hoursLeft%10|0, undefined,
			minutesLeft%100/10|0, minutesLeft%10|0, undefined,
			secondsLeft%100/10|0, secondsLeft%10|0, undefined
		];

		//counterDiv.innerHTML = zf(daysLeft)+"d "+zf(hoursLeft)+"h "+zf(minutesLeft)+"m "+zf(secondsLeft)+"s";
		counterDiv.innerHTML = readableTime(timeLeft|0);
	}
	setInterval(update, 1000);
	requestAnimFrame(update);


}());
